package gov.va.vamf.scheduling.direct.datalayer.eligibility;

import gov.va.vamf.scheduling.direct.domain.ClinicalService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class ClinicalServiceService {

    @Autowired
    private ClinicalServiceRepository clinicalServiceRepository;

    public List<ClinicalService> fetch() {
        List<ClinicalService> clinicalServices = clinicalServiceRepository.findAll();
        return clinicalServices;
    }

    public ClinicalService fetchById(String id) {
        ClinicalService clinicalService = clinicalServiceRepository.findById(id);
        return clinicalService;
    }

    public ClinicalService fetchByName(String name) {
        ClinicalService clinicalService = clinicalServiceRepository.findByName(name);
        return clinicalService;
    }
}
